document.addEventListener("DOMContentLoaded", function() {
    const stars = document.querySelectorAll(".star");
    let rating = 0;

    stars.forEach(star => {
        star.addEventListener("mouseover", function() {
            highlightStars(star.getAttribute("data-value"));
        });

        star.addEventListener("mouseout", function() {
            resetStars();
        });

        star.addEventListener("click", function() {
            rating = star.getAttribute("data-value");
            selectStars(rating);
        });
    });

    document.getElementById("submit-rating").addEventListener("click", function() {
        
        var idCurso = $("#submit-rating").data("id");
        
            var dados = {
				idCurso : idCurso,
				pontuacao: rating,
                cadastrarPontuacao: 0
			}		
			$.post('semRefrescamento/classificacao.php', dados, function(retorna){
				//Mostra dentro da ul os resultado obtidos 
				$(".corpoMensagemPublica").html(retorna);
			});
    });

    function highlightStars(rating) {
        stars.forEach(star => {
            if (star.getAttribute("data-value") <= rating) {
                star.classList.add("highlight");
            } else {
                star.classList.remove("highlight");
            }
        });
    }

    function resetStars() {
        stars.forEach(star => {
            star.classList.remove("highlight");
        });
    }

    function selectStars(rating) {
        stars.forEach(star => {
            if (star.getAttribute("data-value") <= rating) {
                star.classList.add("selected");
            } else {
                star.classList.remove("selected");
            }
        });
    }
});
